/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.keychain;

import com.jetbrains.keychain.KWallet;
import com.jetbrains.keychain.KeychainBackend;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0010H\u0002J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0010H\u0016J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u0010H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0005R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u0010X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/keychain/LinuxKWalletKeychainBackend;", "Lcom/jetbrains/keychain/KeychainBackend;", "()V", "isAvailable", "", "()Z", "kwallet", "Lcom/jetbrains/keychain/KWallet;", "getKwallet", "()Lcom/jetbrains/keychain/KWallet;", "kwallet$delegate", "Lkotlin/Lazy;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "name", "", "getName", "()Ljava/lang/String;", "getDBusWallet", "iface", "path", "getPassword", "service", "account", "setPassword", "", "password", "Companion", "keychain"})
public final class LinuxKWalletKeychainBackend
implements KeychainBackend {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final Logger logger = LoggerFactory.getLogger(LinuxKWalletKeychainBackend.class);
    @NotNull
    private final String name;
    @NotNull
    private final Lazy kwallet$delegate = LazyKt.lazy((Function0)((Function0)new Function0<KWallet>(this){
        final /* synthetic */ LinuxKWalletKeychainBackend this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        @NotNull
        public final KWallet invoke() {
            KWallet kWallet;
            try {
                kWallet = LinuxKWalletKeychainBackend.access$getDBusWallet(this.this$0, "org.kde.kwalletd", "/modules/kwalletd");
            }
            catch (Exception e) {
                kWallet = LinuxKWalletKeychainBackend.access$getDBusWallet(this.this$0, "org.kde.kwalletd5", "/modules/kwalletd5");
            }
            return kWallet;
        }
    }));
    @NotNull
    public static final String KWALLET_INTERFACE = "org.kde.kwalletd";
    @NotNull
    public static final String KWALLET_PATH = "/modules/kwalletd";
    @NotNull
    public static final String KWALLET5_INTERFACE = "org.kde.kwalletd5";
    @NotNull
    public static final String KWALLET5_PATH = "/modules/kwalletd5";

    public LinuxKWalletKeychainBackend() {
        this.name = "linux-kwallet";
    }

    @Override
    public boolean isAvailable() {
        boolean bl;
        try {
            this.getKwallet();
            bl = true;
        }
        catch (Exception e) {
            this.logger.warn("Could not get KWallet", (Throwable)e);
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public String getPassword(@NotNull String service, @NotNull String account) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)account, (String)"account");
        int handle = this.getKwallet().open(this.getKwallet().networkWallet(), 0L, service);
        return this.getKwallet().hasEntry(handle, service, account, service) ? this.getKwallet().readPassword(handle, service, account, service) : null;
    }

    @Override
    public void setPassword(@NotNull String service, @NotNull String account, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)account, (String)"account");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        int handle = this.getKwallet().open(this.getKwallet().networkWallet(), 0L, service);
        this.getKwallet().writePassword(handle, service, account, password, service);
    }

    private final KWallet getKwallet() {
        Lazy lazy = this.kwallet$delegate;
        return (KWallet)lazy.getValue();
    }

    private final KWallet getDBusWallet(String iface, String path) {
        KWallet result = (KWallet)DBusConnection.getConnection((DBusConnection.DBusBusType)DBusConnection.DBusBusType.SESSION, (boolean)true, (int)1000).getRemoteObject(iface, path, KWallet.class);
        result.networkWallet();
        this.logger.info("Using " + iface);
        Intrinsics.checkNotNullExpressionValue((Object)result, (String)"result");
        return result;
    }

    public static final /* synthetic */ KWallet access$getDBusWallet(LinuxKWalletKeychainBackend $this, String iface, String path) {
        return $this.getDBusWallet(iface, path);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/jetbrains/keychain/LinuxKWalletKeychainBackend$Companion;", "", "()V", "KWALLET5_INTERFACE", "", "KWALLET5_PATH", "KWALLET_INTERFACE", "KWALLET_PATH", "keychain"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

