/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.keychain;

import com.jetbrains.keychain.InsecureKeychainBackendKt;
import com.jetbrains.keychain.KeychainBackend;
import java.io.File;
import java.security.Key;
import java.security.spec.KeySpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0010H\u0002J\u0018\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0012H\u0002J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\fH\u0016J\b\u0010\u001a\u001a\u00020\u0010H\u0002J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J \u0010\u001f\u001a\u00020 2\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010!\u001a\u00020\fH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0007R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/jetbrains/keychain/InsecureKeychainBackend;", "Lcom/jetbrains/keychain/KeychainBackend;", "secureSettingsFile", "Ljava/io/File;", "(Ljava/io/File;)V", "isAvailable", "", "()Z", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "name", "", "getName", "()Ljava/lang/String;", "salt", "", "decryptSecureSettings", "Lkotlinx/serialization/json/JsonObject;", "secretKey", "secureData", "encryptSecureSettings", "secret", "getPassword", "service", "account", "getPasswordBytes", "initCipher", "Ljavax/crypto/Cipher;", "mode", "", "setPassword", "", "password", "keychain"})
public final class InsecureKeychainBackend
implements KeychainBackend {
    @NotNull
    private final File secureSettingsFile;
    private final Logger logger;
    private final boolean isAvailable;
    @NotNull
    private final String name;
    @NotNull
    private final byte[] salt;

    public InsecureKeychainBackend(@NotNull File secureSettingsFile) {
        Intrinsics.checkNotNullParameter((Object)secureSettingsFile, (String)"secureSettingsFile");
        this.secureSettingsFile = secureSettingsFile;
        this.logger = LoggerFactory.getLogger(InsecureKeychainBackend.class);
        this.isAvailable = true;
        this.name = "linux-fallback";
        byte[] byArray = new byte[]{-97, -42, 19, -5, 96, 9, 74, 40, -33, 17, 90, 10, 98, -127, -108, -26};
        this.salt = byArray;
    }

    @Override
    public boolean isAvailable() {
        return this.isAvailable;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public String getPassword(@NotNull String service, @NotNull String account) {
        String string;
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)account, (String)"account");
        try {
            String string2;
            this.secureSettingsFile.createNewFile();
            byte[] password = this.getPasswordBytes();
            JsonObject secureSettings = this.decryptSecureSettings(password, FilesKt.readBytes((File)this.secureSettingsFile));
            JsonElement jsonElement = (JsonElement)secureSettings.get((Object)service);
            if (jsonElement == null) {
                string2 = null;
            } else {
                JsonObject jsonObject = InsecureKeychainBackendKt.access$toObject(jsonElement);
                if (jsonObject == null) {
                    string2 = null;
                } else {
                    JsonElement jsonElement2 = (JsonElement)jsonObject.get((Object)account);
                    if (jsonElement2 == null) {
                        string2 = null;
                    } else {
                        JsonPrimitive jsonPrimitive = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement2);
                        string2 = jsonPrimitive == null ? null : JsonElementKt.getContentOrNull((JsonPrimitive)jsonPrimitive);
                    }
                }
            }
            String result = string2;
            FilesKt.writeBytes((File)this.secureSettingsFile, (byte[])this.encryptSecureSettings(password, secureSettings));
            ArraysKt.fill$default((byte[])password, (byte)0, (int)0, (int)0, (int)6, null);
            string = result;
        }
        catch (Throwable t) {
            this.logger.error("Failed read from secure settings", t);
            string = null;
        }
        return string;
    }

    @Override
    public void setPassword(@NotNull String service, @NotNull String account, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)account, (String)"account");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        try {
            this.secureSettingsFile.createNewFile();
            Map secureSettings = MapsKt.toMutableMap((Map)((Map)this.decryptSecureSettings(this.getPasswordBytes(), FilesKt.readBytes((File)this.secureSettingsFile))));
            Object object = secureSettings.computeIfAbsent(service, InsecureKeychainBackend::setPassword$lambda-0);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"secureSettings.computeIf\u2026) { JsonObject(mapOf()) }");
            Map serviceNode = MapsKt.toMutableMap((Map)((Map)JsonElementKt.getJsonObject((JsonElement)object)));
            object = serviceNode;
            JsonPrimitive jsonPrimitive = JsonElementKt.JsonPrimitive((String)password);
            object.put(account, jsonPrimitive);
            object = secureSettings;
            jsonPrimitive = new JsonObject(serviceNode);
            object.put(service, jsonPrimitive);
            FilesKt.writeBytes((File)this.secureSettingsFile, (byte[])this.encryptSecureSettings(this.getPasswordBytes(), new JsonObject(secureSettings)));
            ArraysKt.fill$default((byte[])this.getPasswordBytes(), (byte)0, (int)0, (int)0, (int)6, null);
        }
        catch (Throwable t) {
            this.logger.error("Failed to write secure settings", t);
        }
    }

    private final byte[] getPasswordBytes() {
        String string = System.getProperty("user.name");
        if (string == null) {
            string = "jetbrains";
        }
        String string2 = string;
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    private final Cipher initCipher(byte[] secret, int mode) {
        void $this$mapTo$iv$iv;
        byte[] byArray = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        byte[] iv = byArray;
        IvParameterSpec ivspec = new IvParameterSpec(iv);
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
        byte[] $this$map$iv = secret;
        boolean $i$f$map = false;
        byte[] byArray2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var15_15 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Character.valueOf((char)it));
        }
        int n2 = 256;
        int n3 = 65536;
        byte[] byArray3 = this.salt;
        char[] cArray = CollectionsKt.toCharArray((Collection)((List)destination$iv$iv));
        KeySpec spec = new PBEKeySpec(cArray, byArray3, n3, n2);
        SecretKey tmp = factory.generateSecret(spec);
        SecretKeySpec secretKey = new SecretKeySpec(tmp.getEncoded(), "AES");
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
        Intrinsics.checkNotNullExpressionValue((Object)cipher, (String)"getInstance(\"AES/CBC/PKCS5PADDING\")");
        Cipher cipher2 = cipher;
        cipher2.init(mode, (Key)secretKey, ivspec);
        return cipher2;
    }

    private final JsonObject decryptSecureSettings(byte[] secretKey, byte[] secureData) {
        JsonObject jsonObject;
        try {
            Cipher cipher = this.initCipher(secretKey, 2);
            Json json = InsecureKeychainBackendKt.access$getJsonx$p();
            DeserializationStrategy deserializationStrategy = (DeserializationStrategy)JsonObject.Companion.serializer();
            byte[] byArray = cipher.doFinal(secureData);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"cipher.doFinal(secureData)");
            jsonObject = (JsonObject)json.decodeFromString(deserializationStrategy, new String(byArray, Charsets.UTF_8));
        }
        catch (Throwable t) {
            this.logger.error("Error while decrypting. Reset secure settings and general password", t);
            FilesKt.writeText$default((File)this.secureSettingsFile, (String)"", null, (int)2, null);
            jsonObject = new JsonObject(MapsKt.emptyMap());
        }
        return jsonObject;
    }

    private final byte[] encryptSecureSettings(byte[] secretKey, JsonObject secret) {
        byte[] byArray;
        try {
            Cipher cipher = this.initCipher(secretKey, 1);
            String string = InsecureKeychainBackendKt.access$getJsonx$p().encodeToString((SerializationStrategy)JsonObject.Companion.serializer(), (Object)secret);
            byte[] byArray2 = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
            byArray = cipher.doFinal(byArray2);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"{\n      val cipher = ini\u2026ret).toByteArray())\n    }");
        }
        catch (Throwable t) {
            this.logger.error("Error while encrypting", t);
            byArray = new byte[]{};
        }
        return byArray;
    }

    private static final JsonElement setPassword$lambda-0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (JsonElement)new JsonObject(MapsKt.emptyMap());
    }
}

