/*
 * Decompiled with CFR 0.152.
 */
package com.github.markusbernhardt.proxy.util;

import com.github.markusbernhardt.proxy.util.EmptyXMLResolver;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class PListParser {
    private static final PListParser PLIST = new PListParser();
    private static final String BASE64_STRING = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    private static final char[] BASE64_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
    private final DateFormat m_dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private final Map<Class<?>, ElementType> m_simpleTypes;

    static void silentlyClose(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static Dict parse(InputSource input) throws XmlParseException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            documentBuilderFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setEntityResolver(new EmptyXMLResolver());
            Document doc = documentBuilder.parse(input);
            Element element = doc.getDocumentElement();
            return PLIST.parse(element);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new XmlParseException("Error reading input", e);
        }
    }

    public static Dict load(File file) throws XmlParseException, IOException {
        try (FileInputStream byteStream = new FileInputStream(file);){
            InputSource input = new InputSource(byteStream);
            Dict dict = PListParser.parse(input);
            return dict;
        }
    }

    PListParser() {
        this.m_dateFormat.setTimeZone(TimeZone.getTimeZone("Z"));
        this.m_simpleTypes = new HashMap();
        this.m_simpleTypes.put(Integer.class, ElementType.INTEGER);
        this.m_simpleTypes.put(Byte.class, ElementType.INTEGER);
        this.m_simpleTypes.put(Short.class, ElementType.INTEGER);
        this.m_simpleTypes.put(Short.class, ElementType.INTEGER);
        this.m_simpleTypes.put(Long.class, ElementType.INTEGER);
        this.m_simpleTypes.put(String.class, ElementType.STRING);
        this.m_simpleTypes.put(Float.class, ElementType.REAL);
        this.m_simpleTypes.put(Double.class, ElementType.REAL);
        this.m_simpleTypes.put(byte[].class, ElementType.DATA);
        this.m_simpleTypes.put(Boolean.class, ElementType.TRUE);
        this.m_simpleTypes.put(Date.class, ElementType.DATE);
    }

    Dict parse(Element element) throws XmlParseException {
        Node n;
        if (!"plist".equalsIgnoreCase(element.getNodeName())) {
            throw new XmlParseException("Expected plist top element, was: " + element.getNodeName());
        }
        for (n = element.getFirstChild(); n != null && !n.getNodeName().equals("dict"); n = n.getNextSibling()) {
        }
        Dict result = (Dict)this.parseElement(n);
        return result;
    }

    private Object parseElement(Node element) throws XmlParseException {
        try {
            return this.parseElementRaw(element);
        }
        catch (Exception e) {
            throw new XmlParseException("Failed to parse: " + element.getNodeName(), e);
        }
    }

    private Object parseElementRaw(Node element) throws ParseException {
        ElementType type = ElementType.valueOf(element.getNodeName().toUpperCase());
        switch (type) {
            case INTEGER: {
                return this.parseInt(this.getValue(element));
            }
            case REAL: {
                return Double.valueOf(this.getValue(element));
            }
            case STRING: {
                return this.getValue(element);
            }
            case DATE: {
                return this.m_dateFormat.parse(this.getValue(element));
            }
            case DATA: {
                return PListParser.base64decode(this.getValue(element));
            }
            case ARRAY: {
                return this.parseArray(element.getChildNodes());
            }
            case TRUE: {
                return Boolean.TRUE;
            }
            case FALSE: {
                return Boolean.FALSE;
            }
            case DICT: {
                return this.parseDict(element.getChildNodes());
            }
        }
        throw new RuntimeException("Unexpected type: " + element.getNodeName());
    }

    private String getValue(Node n) {
        StringBuilder sb = new StringBuilder();
        for (Node c = n.getFirstChild(); c != null; c = c.getNextSibling()) {
            if (c.getNodeType() != 3) continue;
            sb.append(c.getNodeValue());
        }
        return sb.toString();
    }

    private Number parseInt(String value) {
        Long l = Long.valueOf(value);
        if ((long)l.intValue() == l) {
            return l.intValue();
        }
        return l;
    }

    private Dict parseDict(NodeList elements) throws ParseException {
        Dict dict = new Dict();
        for (int i = 0; i < elements.getLength(); ++i) {
            Node key = elements.item(i);
            if (key.getNodeType() != 1) continue;
            if (!"key".equals(key.getNodeName())) {
                throw new ParseException("Expected key but was " + key.getNodeName(), -1);
            }
            Node value = elements.item(++i);
            while (value.getNodeType() != 1) {
                value = elements.item(++i);
            }
            Object o = this.parseElementRaw(value);
            String dictName = this.getValue(key);
            dict.children.put(dictName, o);
        }
        return dict;
    }

    private List<Object> parseArray(NodeList elements) throws ParseException {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < elements.getLength(); ++i) {
            Node o = elements.item(i);
            if (o.getNodeType() != 1) continue;
            list.add(this.parseElementRaw(o));
        }
        return list;
    }

    static String base64encode(byte[] bytes) {
        StringBuilder builder = new StringBuilder((bytes.length + 2) / 3 * 4);
        for (int i = 0; i < bytes.length; i += 3) {
            byte b0 = bytes[i];
            byte b1 = i < bytes.length - 1 ? bytes[i + 1] : (byte)0;
            byte b2 = i < bytes.length - 2 ? bytes[i + 2] : (byte)0;
            builder.append(BASE64_CHARS[(b0 & 0xFF) >> 2]);
            builder.append(BASE64_CHARS[(b0 & 3) << 4 | (b1 & 0xF0) >> 4]);
            builder.append(i < bytes.length - 1 ? Character.valueOf(BASE64_CHARS[(b1 & 0xF) << 2 | (b2 & 0xC0) >> 6]) : "=");
            builder.append(i < bytes.length - 2 ? Character.valueOf(BASE64_CHARS[b2 & 0x3F]) : "=");
        }
        return builder.toString();
    }

    static byte[] base64decode(String base64) {
        int endTrim = (base64 = base64.trim()).endsWith("==") ? 2 : (base64.endsWith("=") ? 1 : 0);
        int length = base64.length() / 4 * 3 - endTrim;
        base64 = base64.replace('=', 'A');
        byte[] result = new byte[length];
        int stringLength = base64.length();
        int index = 0;
        for (int i = 0; i < stringLength; i += 4) {
            int i0 = BASE64_STRING.indexOf(base64.charAt(i));
            int i1 = BASE64_STRING.indexOf(base64.charAt(i + 1));
            int i2 = BASE64_STRING.indexOf(base64.charAt(i + 2));
            int i3 = BASE64_STRING.indexOf(base64.charAt(i + 3));
            byte b0 = (byte)(i0 << 2 | i1 >> 4);
            byte b1 = (byte)(i1 << 4 | i2 >> 2);
            byte b2 = (byte)(i2 << 6 | i3);
            result[index++] = b0;
            if (index >= length) continue;
            result[index++] = b1;
            if (index >= length) continue;
            result[index++] = b2;
        }
        return result;
    }

    private static enum ElementType {
        INTEGER,
        STRING,
        REAL,
        DATA,
        DATE,
        DICT,
        ARRAY,
        TRUE,
        FALSE;

    }

    public static class Dict
    implements Iterable<Map.Entry<String, Object>> {
        private Map<String, Object> children = new HashMap<String, Object>();

        public Object get(String key) {
            return this.children.get(key);
        }

        @Override
        public Iterator<Map.Entry<String, Object>> iterator() {
            return this.children.entrySet().iterator();
        }

        public int size() {
            return this.children.size();
        }

        public void dump() {
            System.out.println("PList");
            Dict.dumpInternal(this, 1);
        }

        private static void dumpInternal(Dict plist, int indent) {
            for (Map.Entry<String, Object> child : plist) {
                int j;
                if (child.getValue() instanceof Dict) {
                    for (j = 0; j < indent; ++j) {
                        System.out.print("  ");
                    }
                    System.out.println(child.getKey());
                    Dict.dumpInternal((Dict)child.getValue(), indent + 1);
                    continue;
                }
                for (j = 0; j < indent; ++j) {
                    System.out.print("  ");
                }
                System.out.println(child.getKey() + " = " + child.getValue());
            }
        }

        public Object getAtPath(String path) {
            Dict currentNode = this;
            String[] pathSegments = path.trim().split("/");
            for (int i = 0; i < pathSegments.length; ++i) {
                String segment = pathSegments[i].trim();
                if (segment.length() == 0) continue;
                Object o = currentNode.get(segment);
                if (i >= pathSegments.length - 1) {
                    return o;
                }
                if (o == null || !(o instanceof Dict)) break;
                currentNode = (Dict)o;
            }
            return null;
        }
    }

    public static class XmlParseException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public XmlParseException() {
        }

        public XmlParseException(String msg) {
            super(msg);
        }

        public XmlParseException(String msg, Exception e) {
            super(msg, e);
        }
    }
}

