/*
 * Decompiled with CFR 0.152.
 */
package com.github.markusbernhardt.proxy.selector.misc;

import java.io.IOException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class ListProxySelector
extends ProxySelector {
    private final List<ProxySelector> selectors;
    private final ProxySelector fallbackSelector;

    public ListProxySelector(List<ProxySelector> selectors, ProxySelector fallbackSelector) {
        this.selectors = selectors;
        this.fallbackSelector = fallbackSelector;
    }

    @Override
    public List<Proxy> select(URI uri) {
        ArrayList<Proxy> proxies = new ArrayList<Proxy>();
        for (ProxySelector selector : this.selectors) {
            List<Proxy> l = selector.select(uri);
            if (l == null || l.size() <= 0) continue;
            proxies.addAll(l);
        }
        if (proxies.isEmpty() && this.fallbackSelector != null) {
            proxies.addAll(this.fallbackSelector.select(uri));
        }
        proxies.add(Proxy.NO_PROXY);
        return this.removeDuplicates(proxies);
    }

    private List<Proxy> removeDuplicates(List<Proxy> proxies) {
        ArrayList<Proxy> l = new ArrayList<Proxy>(proxies.size());
        HashSet<Proxy> s = new HashSet<Proxy>();
        for (Proxy proxy : proxies) {
            if (s.contains(proxy)) continue;
            l.add(proxy);
            s.add(proxy);
        }
        return l;
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
        for (ProxySelector selector : this.selectors) {
            selector.connectFailed(uri, sa, ioe);
        }
        if (this.fallbackSelector != null) {
            this.fallbackSelector.connectFailed(uri, sa, ioe);
        }
    }
}

