/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg;

import com.github.weisj.jsvg.SVGRenderingHints;
import com.github.weisj.jsvg.attributes.ViewBox;
import com.github.weisj.jsvg.attributes.font.SVGFont;
import com.github.weisj.jsvg.geometry.size.FloatSize;
import com.github.weisj.jsvg.geometry.size.MeasureContext;
import com.github.weisj.jsvg.nodes.SVG;
import com.github.weisj.jsvg.renderer.Graphics2DOutput;
import com.github.weisj.jsvg.renderer.NodeRenderer;
import com.github.weisj.jsvg.renderer.Output;
import com.github.weisj.jsvg.renderer.RenderContext;
import com.github.weisj.jsvg.renderer.ShapeOutput;
import com.github.weisj.jsvg.renderer.awt.AwtComponentPlatformSupport;
import com.github.weisj.jsvg.renderer.awt.NullPlatformSupport;
import com.github.weisj.jsvg.renderer.awt.PlatformSupport;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SVGDocument {
    private static final boolean DEBUG = false;
    @NotNull
    private final SVG root;
    @NotNull
    private final FloatSize size;

    public SVGDocument(@NotNull SVG root) {
        this.root = root;
        float em = SVGFont.defaultFontSize();
        this.size = root.sizeForTopLevel(em, SVGFont.exFromEm(em));
    }

    @NotNull
    public FloatSize size() {
        return this.size;
    }

    @NotNull
    public ViewBox viewBox() {
        return this.root.staticViewBox(this.size());
    }

    @NotNull
    public Shape computeShape() {
        return this.computeShape(null);
    }

    @NotNull
    public Shape computeShape(@Nullable ViewBox viewBox) {
        Area accumulator = new Area(new Path2D.Float());
        this.renderWithPlatform((PlatformSupport)NullPlatformSupport.INSTANCE, new ShapeOutput(accumulator), viewBox);
        return accumulator;
    }

    public void render(@Nullable JComponent component, @NotNull Graphics2D g) {
        this.render(component, g, null);
    }

    @Deprecated
    public void render(@Nullable JComponent component, @NotNull Graphics2D graphics2D, @Nullable ViewBox bounds) {
        this.render((Component)component, graphics2D, bounds);
    }

    public void render(@Nullable Component component, @NotNull Graphics2D graphics2D, @Nullable ViewBox bounds) {
        PlatformSupport platformSupport = component != null ? new AwtComponentPlatformSupport(component) : NullPlatformSupport.INSTANCE;
        this.renderWithPlatform(platformSupport, graphics2D, bounds);
    }

    private float computePlatformFontSize(@NotNull PlatformSupport platformSupport, @NotNull Output output) {
        return output.contextFontSize().orElseGet(platformSupport::fontSize).floatValue();
    }

    public void renderWithPlatform(@NotNull PlatformSupport platformSupport, @NotNull Graphics2D graphics2D, @Nullable ViewBox bounds) {
        Graphics2D g = (Graphics2D)graphics2D.create();
        this.setupSVGRenderingHints(g);
        Graphics2DOutput output = new Graphics2DOutput(g);
        this.renderWithPlatform(platformSupport, output, bounds);
        output.dispose();
    }

    public void renderWithPlatform(@NotNull PlatformSupport platformSupport, @NotNull Output output, @Nullable ViewBox bounds) {
        RenderContext context = this.prepareRenderContext(platformSupport, output, bounds);
        if (bounds == null) {
            bounds = new ViewBox(this.root.size(context));
        }
        output.applyClip(bounds);
        output.translate(bounds.x, bounds.y);
        NodeRenderer.renderWithSize(this.root, bounds.size(), context, output, null);
    }

    @NotNull
    private RenderContext prepareRenderContext(@NotNull PlatformSupport platformSupport, @NotNull Output output, @Nullable ViewBox bounds) {
        float defaultEm = this.computePlatformFontSize(platformSupport, output);
        float defaultEx = SVGFont.exFromEm(defaultEm);
        MeasureContext initialMeasure = bounds != null ? MeasureContext.createInitial(bounds.size(), defaultEm, defaultEx) : MeasureContext.createInitial(this.root.sizeForTopLevel(defaultEm, defaultEx), defaultEm, defaultEx);
        RenderContext context = RenderContext.createInitial(platformSupport, initialMeasure);
        this.root.applyTransform(output, context);
        return context;
    }

    private void setupSVGRenderingHints(@NotNull Graphics2D g) {
        Object aaHint = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        if (aaHint != RenderingHints.VALUE_ANTIALIAS_DEFAULT) {
            this.setSVGRenderingHint(g, SVGRenderingHints.KEY_IMAGE_ANTIALIASING, aaHint == RenderingHints.VALUE_ANTIALIAS_ON ? SVGRenderingHints.VALUE_IMAGE_ANTIALIASING_ON : SVGRenderingHints.VALUE_IMAGE_ANTIALIASING_OFF);
        } else {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (g.getRenderingHint(RenderingHints.KEY_STROKE_CONTROL) == RenderingHints.VALUE_STROKE_DEFAULT) {
            g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        }
        this.setSVGRenderingHint(g, SVGRenderingHints.KEY_MASK_CLIP_RENDERING, SVGRenderingHints.VALUE_MASK_CLIP_RENDERING_DEFAULT);
    }

    private void setSVGRenderingHint(@NotNull Graphics2D g, @NotNull RenderingHints.Key key, @NotNull Object o) {
        if (g.getRenderingHint(key) == null) {
            g.setRenderingHint(key, o);
        }
    }

    private static /* synthetic */ void lambda$renderWithPlatform$0(ViewBox finalBounds, Graphics2D g) {
        g.setColor(Color.RED);
        g.draw(finalBounds);
    }
}

