/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls;

import io.ktor.network.tls.CipherSuite;
import io.ktor.network.tls.HashesKt;
import io.ktor.network.tls.KeysKt;
import io.ktor.network.tls.RenderKt;
import io.ktor.network.tls.TLSException;
import io.ktor.network.tls.TLSHandshakeType;
import io.ktor.network.tls.TLSRecord;
import io.ktor.network.tls.TLSVersion;
import io.ktor.network.tls.extensions.HashAndSign;
import io.ktor.network.tls.extensions.NamedCurve;
import io.ktor.network.tls.extensions.NamedCurvesKt;
import io.ktor.network.tls.extensions.PointFormat;
import io.ktor.network.tls.extensions.PointFormatKt;
import io.ktor.network.tls.extensions.SignatureAlgorithmKt;
import io.ktor.network.tls.extensions.TLSExtensionType;
import io.ktor.utils.io.ByteWriteChannel;
import io.ktor.utils.io.ByteWriteChannelOperationsKt;
import io.ktor.utils.io.core.BytePacketBuilderKt;
import io.ktor.utils.io.core.ByteReadPacketKt;
import io.ktor.utils.io.core.StringsKt;
import java.security.Key;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECPoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.io.Buffer;
import kotlinx.io.Sink;
import kotlinx.io.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\u001a\u001c\u0010\u0004\u001a\u00020\u0003*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001H\u0080@\u00a2\u0006\u0004\b\u0004\u0010\u0005\u001a#\u0010\u000b\u001a\u00020\u0003*\u00020\u00062\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tH\u0000\u00a2\u0006\u0004\b\u000b\u0010\f\u001aE\u0010\u0017\u001a\u00020\u0003*\u00020\u00062\u0006\u0010\u000e\u001a\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0015H\u0000\u00a2\u0006\u0004\b\u0017\u0010\u0018\u001a!\u0010\u001c\u001a\u00020\u0003*\u00020\u00062\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0000\u00a2\u0006\u0004\b\u001c\u0010\u001d\u001a+\u0010\"\u001a\u00020\u0003*\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010\u0013\u001a\u00020!H\u0000\u00a2\u0006\u0004\b\"\u0010#\u001a\u001f\u0010(\u001a\u00020'2\u0006\u0010$\u001a\u00020\u00122\u0006\u0010&\u001a\u00020%H\u0000\u00a2\u0006\u0004\b(\u0010)\u001a)\u0010+\u001a\u00020\u00122\u0006\u0010*\u001a\u00020\u00122\u0006\u0010&\u001a\u00020%2\b\b\u0002\u0010\n\u001a\u00020\tH\u0000\u00a2\u0006\u0004\b+\u0010,\u001a\u001b\u0010.\u001a\u00020\u0003*\u00020\u00062\u0006\u0010-\u001a\u00020\u001fH\u0000\u00a2\u0006\u0004\b.\u0010/\u001a#\u00103\u001a\u00020\u0003*\u00020\u00062\u0006\u00101\u001a\u0002002\u0006\u00102\u001a\u00020\tH\u0000\u00a2\u0006\u0004\b3\u00104\u001a\u001f\u00107\u001a\u00020'2\u000e\b\u0002\u00106\u001a\b\u0012\u0004\u0012\u0002050\u000fH\u0002\u00a2\u0006\u0004\b7\u00108\u001a\u0017\u0010:\u001a\u00020'2\u0006\u00109\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b:\u0010;\u001a\u001f\u0010>\u001a\u00020'2\u000e\b\u0002\u0010=\u001a\b\u0012\u0004\u0012\u00020<0\u000fH\u0002\u00a2\u0006\u0004\b>\u00108\u001a\u001f\u0010A\u001a\u00020'2\u000e\b\u0002\u0010@\u001a\b\u0012\u0004\u0012\u00020?0\u000fH\u0002\u00a2\u0006\u0004\bA\u00108\u001a#\u0010C\u001a\u00020\u0003*\u00020\u00062\u0006\u0010B\u001a\u00020\u00122\u0006\u00102\u001a\u00020\tH\u0002\u00a2\u0006\u0004\bC\u0010D\u001a\u001b\u0010F\u001a\u00020\u0003*\u00020\u00062\u0006\u0010E\u001a\u00020\tH\u0002\u00a2\u0006\u0004\bF\u0010G\"\u0014\u0010H\u001a\u00020\t8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\bH\u0010I\"\u0014\u0010J\u001a\u00020\t8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\bJ\u0010I\u00a8\u0006K"}, d2={"Lio/ktor/utils/io/ByteWriteChannel;", "Lio/ktor/network/tls/TLSRecord;", "record", "", "writeRecord", "(Lio/ktor/utils/io/ByteWriteChannel;Lio/ktor/network/tls/TLSRecord;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Lkotlinx/io/Sink;", "Lio/ktor/network/tls/TLSHandshakeType;", "type", "", "length", "writeTLSHandshakeType", "(Lkotlinx/io/Sink;Lio/ktor/network/tls/TLSHandshakeType;I)V", "Lio/ktor/network/tls/TLSVersion;", "version", "", "Lio/ktor/network/tls/CipherSuite;", "suites", "", "random", "sessionId", "", "serverName", "writeTLSClientHello", "(Lkotlinx/io/Sink;Lio/ktor/network/tls/TLSVersion;Ljava/util/List;[B[BLjava/lang/String;)V", "", "Ljava/security/cert/X509Certificate;", "certificates", "writeTLSCertificates", "(Lkotlinx/io/Sink;[Ljava/security/cert/X509Certificate;)V", "preSecret", "Ljava/security/PublicKey;", "publicKey", "Ljava/security/SecureRandom;", "writeEncryptedPreMasterSecret", "(Lkotlinx/io/Sink;[BLjava/security/PublicKey;Ljava/security/SecureRandom;)V", "digest", "Ljavax/crypto/SecretKey;", "secretKey", "Lkotlinx/io/Source;", "finished", "([BLjavax/crypto/SecretKey;)Lkotlinx/io/Source;", "handshakeHash", "serverFinished", "([BLjavax/crypto/SecretKey;I)[B", "key", "writePublicKeyUncompressed", "(Lkotlinx/io/Sink;Ljava/security/PublicKey;)V", "Ljava/security/spec/ECPoint;", "point", "fieldSize", "writeECPoint", "(Lkotlinx/io/Sink;Ljava/security/spec/ECPoint;I)V", "Lio/ktor/network/tls/extensions/HashAndSign;", "algorithms", "buildSignatureAlgorithmsExtension", "(Ljava/util/List;)Lkotlinx/io/Source;", "name", "buildServerNameExtension", "(Ljava/lang/String;)Lkotlinx/io/Source;", "Lio/ktor/network/tls/extensions/NamedCurve;", "curves", "buildECCurvesExtension", "Lio/ktor/network/tls/extensions/PointFormat;", "formats", "buildECPointFormatExtension", "src", "writeAligned", "(Lkotlinx/io/Sink;[BI)V", "value", "writeTripleByteLength", "(Lkotlinx/io/Sink;I)V", "MAX_SERVER_NAME_LENGTH", "I", "MAX_CURVES_QUANTITY", "ktor-network-tls"})
@SourceDebugExtension(value={"SMAP\nRender.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Render.kt\nio/ktor/network/tls/RenderKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Builder.kt\nio/ktor/utils/io/core/BuilderKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,209:1\n1#2:210\n21#3,3:211\n21#3,3:214\n21#3,3:217\n21#3,2:220\n23#3:224\n21#3,3:225\n21#3,2:228\n23#3:232\n21#3,2:233\n23#3:237\n1869#4,2:222\n1869#4,2:230\n1869#4,2:235\n1694#5,6:238\n*S KotlinDebug\n*F\n+ 1 Render.kt\nio/ktor/network/tls/RenderKt\n*L\n75#1:211,3\n104#1:214,3\n122#1:217,3\n134#1:220,2\n134#1:224\n149#1:225,3\n164#1:228,2\n164#1:232\n182#1:233,2\n182#1:237\n141#1:222,2\n175#1:230,2\n189#1:235,2\n196#1:238,6\n*E\n"})
public final class RenderKt {
    private static final int MAX_SERVER_NAME_LENGTH = 32762;
    private static final int MAX_CURVES_QUANTITY = 16382;

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object writeRecord(@NotNull ByteWriteChannel $this$writeRecord, @NotNull TLSRecord record, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof writeRecord.1)) ** GOTO lbl-1000
        var6_3 = $completion;
        if ((var6_3.label & -2147483648) != 0) {
            var6_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                Object L$0;
                Object L$1;
                Object L$2;
                int I$0;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return RenderKt.writeRecord(null, null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$writeRecord_u24lambda_u240 = record;
                $i$a$-with-RenderKt$writeRecord$2 = 0;
                $continuation.L$0 = $this$writeRecord;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)record);
                $continuation.L$2 = $this$writeRecord_u24lambda_u240;
                $continuation.I$0 = $i$a$-with-RenderKt$writeRecord$2;
                $continuation.label = 1;
                v0 = ByteWriteChannelOperationsKt.writeByte((ByteWriteChannel)$this$writeRecord, (byte)((byte)$this$writeRecord_u24lambda_u240.getType().getCode()), (Continuation)$continuation);
                if (v0 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl30
            }
            case 1: {
                $i$a$-with-RenderKt$writeRecord$2 = $continuation.I$0;
                $this$writeRecord_u24lambda_u240 = (TLSRecord)$continuation.L$2;
                record = (TLSRecord)$continuation.L$1;
                $this$writeRecord = (ByteWriteChannel)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl30:
                // 2 sources

                $continuation.L$0 = $this$writeRecord;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)record);
                $continuation.L$2 = $this$writeRecord_u24lambda_u240;
                $continuation.I$0 = $i$a$-with-RenderKt$writeRecord$2;
                $continuation.label = 2;
                v1 = ByteWriteChannelOperationsKt.writeByte((ByteWriteChannel)$this$writeRecord, (byte)((byte)($this$writeRecord_u24lambda_u240.getVersion().getCode() >> 8)), (Continuation)$continuation);
                if (v1 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl46
            }
            case 2: {
                $i$a$-with-RenderKt$writeRecord$2 = $continuation.I$0;
                $this$writeRecord_u24lambda_u240 = (TLSRecord)$continuation.L$2;
                record = (TLSRecord)$continuation.L$1;
                $this$writeRecord = (ByteWriteChannel)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl46:
                // 2 sources

                $continuation.L$0 = $this$writeRecord;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)record);
                $continuation.L$2 = $this$writeRecord_u24lambda_u240;
                $continuation.I$0 = $i$a$-with-RenderKt$writeRecord$2;
                $continuation.label = 3;
                v2 = ByteWriteChannelOperationsKt.writeByte((ByteWriteChannel)$this$writeRecord, (byte)((byte)$this$writeRecord_u24lambda_u240.getVersion().getCode()), (Continuation)$continuation);
                if (v2 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl62
            }
            case 3: {
                $i$a$-with-RenderKt$writeRecord$2 = $continuation.I$0;
                $this$writeRecord_u24lambda_u240 = (TLSRecord)$continuation.L$2;
                record = (TLSRecord)$continuation.L$1;
                $this$writeRecord = (ByteWriteChannel)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl62:
                // 2 sources

                $continuation.L$0 = $this$writeRecord;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)record);
                $continuation.L$2 = $this$writeRecord_u24lambda_u240;
                $continuation.I$0 = $i$a$-with-RenderKt$writeRecord$2;
                $continuation.label = 4;
                v3 = ByteWriteChannelOperationsKt.writeShort((ByteWriteChannel)$this$writeRecord, (short)((short)ByteReadPacketKt.getRemaining((Source)$this$writeRecord_u24lambda_u240.getPacket())), (Continuation)$continuation);
                if (v3 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl78
            }
            case 4: {
                $i$a$-with-RenderKt$writeRecord$2 = $continuation.I$0;
                $this$writeRecord_u24lambda_u240 = (TLSRecord)$continuation.L$2;
                record = (TLSRecord)$continuation.L$1;
                $this$writeRecord = (ByteWriteChannel)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl78:
                // 2 sources

                $continuation.L$0 = $this$writeRecord;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)record);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)$this$writeRecord_u24lambda_u240);
                $continuation.I$0 = $i$a$-with-RenderKt$writeRecord$2;
                $continuation.label = 5;
                v4 = ByteWriteChannelOperationsKt.writePacket((ByteWriteChannel)$this$writeRecord, (Source)$this$writeRecord_u24lambda_u240.getPacket(), (Continuation)$continuation);
                if (v4 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl94
            }
            case 5: {
                $i$a$-with-RenderKt$writeRecord$2 = $continuation.I$0;
                $this$writeRecord_u24lambda_u240 = (TLSRecord)$continuation.L$2;
                record = (TLSRecord)$continuation.L$1;
                $this$writeRecord = (ByteWriteChannel)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl94:
                // 2 sources

                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$writeRecord);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)record);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)$this$writeRecord_u24lambda_u240);
                $continuation.I$0 = $i$a$-with-RenderKt$writeRecord$2;
                $continuation.label = 6;
                v5 = $this$writeRecord.flush((Continuation)$continuation);
                if (v5 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl110
            }
            case 6: {
                $i$a$-with-RenderKt$writeRecord$2 = $continuation.I$0;
                $this$writeRecord_u24lambda_u240 = (TLSRecord)$continuation.L$2;
                record = (TLSRecord)$continuation.L$1;
                $this$writeRecord = (ByteWriteChannel)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v5 = $result;
lbl110:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static final void writeTLSHandshakeType(@NotNull Sink $this$writeTLSHandshakeType, @NotNull TLSHandshakeType type, int length) {
        Intrinsics.checkNotNullParameter((Object)$this$writeTLSHandshakeType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        if (length > 0xFFFFFF) {
            throw new TLSException("TLS handshake size limit exceeded: " + length, null, 2, null);
        }
        int v = type.getCode() << 24 | length;
        $this$writeTLSHandshakeType.writeInt(v);
    }

    /*
     * WARNING - void declaration
     */
    public static final void writeTLSClientHello(@NotNull Sink $this$writeTLSClientHello, @NotNull TLSVersion version, @NotNull List<CipherSuite> suites, @NotNull byte[] random, @NotNull byte[] sessionId, @Nullable String serverName) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$writeTLSClientHello, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)version), (String)"version");
        Intrinsics.checkNotNullParameter(suites, (String)"suites");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        $this$writeTLSClientHello.writeShort((short)version.getCode());
        BytePacketBuilderKt.writeFully$default((Sink)$this$writeTLSClientHello, (byte[])random, (int)0, (int)0, (int)6, null);
        int sessionIdLength = sessionId.length;
        if (sessionIdLength < 0 || sessionIdLength > 255 || sessionIdLength > sessionId.length) {
            throw new TLSException("Illegal sessionIdLength", null, 2, null);
        }
        $this$writeTLSClientHello.writeByte((byte)sessionIdLength);
        BytePacketBuilderKt.writeFully((Sink)$this$writeTLSClientHello, (byte[])sessionId, (int)0, (int)sessionIdLength);
        $this$writeTLSClientHello.writeShort((short)(suites.size() * 2));
        for (CipherSuite suite : suites) {
            $this$writeTLSClientHello.writeShort(suite.getCode());
        }
        $this$writeTLSClientHello.writeByte((byte)1);
        $this$writeTLSClientHello.writeByte((byte)0);
        ArrayList extensions = new ArrayList();
        ((Collection)extensions).add(RenderKt.buildSignatureAlgorithmsExtension$default(null, 1, null));
        ((Collection)extensions).add(RenderKt.buildECCurvesExtension$default(null, 1, null));
        ((Collection)extensions).add(RenderKt.buildECPointFormatExtension$default(null, 1, null));
        String string = serverName;
        if (string != null) {
            String name = string;
            boolean bl = false;
            ((Collection)extensions).add(RenderKt.buildServerNameExtension(name));
        }
        Object object = extensions;
        Sink sink = $this$writeTLSClientHello;
        int name = 0;
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            void it;
            Object t = iterator.next();
            Source source = (Source)t;
            n = name;
            boolean bl = false;
            int n2 = (int)ByteReadPacketKt.getRemaining((Source)it);
            name = n + n2;
        }
        n = name;
        sink.writeShort((short)n);
        Iterator iterator2 = extensions.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        object = iterator2;
        while (object.hasNext()) {
            Object e = object.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            Source e2 = (Source)e;
            BytePacketBuilderKt.writePacket((Sink)$this$writeTLSClientHello, (Source)e2);
        }
    }

    public static /* synthetic */ void writeTLSClientHello$default(Sink sink, TLSVersion tLSVersion, List list, byte[] byArray, byte[] byArray2, String string, int n, Object object) {
        if ((n & 0x10) != 0) {
            string = null;
        }
        RenderKt.writeTLSClientHello(sink, tLSVersion, list, byArray, byArray2, string);
    }

    public static final void writeTLSCertificates(@NotNull Sink $this$writeTLSCertificates, @NotNull X509Certificate[] certificates) {
        Intrinsics.checkNotNullParameter((Object)$this$writeTLSCertificates, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)certificates, (String)"certificates");
        boolean $i$f$buildPacket = false;
        Buffer builder$iv = new Buffer();
        Sink $this$writeTLSCertificates_u24lambda_u243 = (Sink)builder$iv;
        boolean bl = false;
        for (X509Certificate certificate : certificates) {
            byte[] certificateBytes;
            Intrinsics.checkNotNull((Object)certificate.getEncoded());
            RenderKt.writeTripleByteLength($this$writeTLSCertificates_u24lambda_u243, certificateBytes.length);
            BytePacketBuilderKt.writeFully$default((Sink)$this$writeTLSCertificates_u24lambda_u243, (byte[])certificateBytes, (int)0, (int)0, (int)6, null);
        }
        Source chain = (Source)builder$iv;
        RenderKt.writeTripleByteLength($this$writeTLSCertificates, (int)ByteReadPacketKt.getRemaining((Source)chain));
        BytePacketBuilderKt.writePacket((Sink)$this$writeTLSCertificates, (Source)chain);
    }

    public static final void writeEncryptedPreMasterSecret(@NotNull Sink $this$writeEncryptedPreMasterSecret, @NotNull byte[] preSecret, @NotNull PublicKey publicKey, @NotNull SecureRandom random) {
        Intrinsics.checkNotNullParameter((Object)$this$writeEncryptedPreMasterSecret, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)preSecret, (String)"preSecret");
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        if (!(preSecret.length == 48)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        Intrinsics.checkNotNull((Object)cipher);
        Cipher rsaCipher = cipher;
        rsaCipher.init(1, (Key)publicKey, random);
        byte[] encryptedSecret = rsaCipher.doFinal(preSecret);
        if (encryptedSecret.length > 65535) {
            throw new TLSException("Encrypted premaster secret is too long", null, 2, null);
        }
        $this$writeEncryptedPreMasterSecret.writeShort((short)encryptedSecret.length);
        Intrinsics.checkNotNull((Object)encryptedSecret);
        BytePacketBuilderKt.writeFully$default((Sink)$this$writeEncryptedPreMasterSecret, (byte[])encryptedSecret, (int)0, (int)0, (int)6, null);
    }

    @NotNull
    public static final Source finished(@NotNull byte[] digest, @NotNull SecretKey secretKey) {
        Intrinsics.checkNotNullParameter((Object)digest, (String)"digest");
        Intrinsics.checkNotNullParameter((Object)secretKey, (String)"secretKey");
        boolean $i$f$buildPacket = false;
        Buffer builder$iv = new Buffer();
        Sink $this$finished_u24lambda_u244 = (Sink)builder$iv;
        boolean bl = false;
        byte[] prf = HashesKt.PRF(secretKey, KeysKt.getCLIENT_FINISHED_LABEL(), digest, 12);
        BytePacketBuilderKt.writeFully$default((Sink)$this$finished_u24lambda_u244, (byte[])prf, (int)0, (int)0, (int)6, null);
        return (Source)builder$iv;
    }

    @NotNull
    public static final byte[] serverFinished(@NotNull byte[] handshakeHash, @NotNull SecretKey secretKey, int length) {
        Intrinsics.checkNotNullParameter((Object)handshakeHash, (String)"handshakeHash");
        Intrinsics.checkNotNullParameter((Object)secretKey, (String)"secretKey");
        return HashesKt.PRF(secretKey, KeysKt.getSERVER_FINISHED_LABEL(), handshakeHash, length);
    }

    public static /* synthetic */ byte[] serverFinished$default(byte[] byArray, SecretKey secretKey, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 12;
        }
        return RenderKt.serverFinished(byArray, secretKey, n);
    }

    public static final void writePublicKeyUncompressed(@NotNull Sink $this$writePublicKeyUncompressed, @NotNull PublicKey key) {
        Intrinsics.checkNotNullParameter((Object)$this$writePublicKeyUncompressed, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (!(key instanceof ECPublicKey)) {
            throw new TLSException("Unsupported public key type: " + key, null, 2, null);
        }
        int fieldSize = ((ECPublicKey)key).getParams().getCurve().getField().getFieldSize();
        ECPoint eCPoint = ((ECPublicKey)key).getW();
        Intrinsics.checkNotNullExpressionValue((Object)eCPoint, (String)"getW(...)");
        RenderKt.writeECPoint($this$writePublicKeyUncompressed, eCPoint, fieldSize);
    }

    public static final void writeECPoint(@NotNull Sink $this$writeECPoint, @NotNull ECPoint point, int fieldSize) {
        Intrinsics.checkNotNullParameter((Object)$this$writeECPoint, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        boolean $i$f$buildPacket = false;
        Buffer builder$iv = new Buffer();
        Sink $this$writeECPoint_u24lambda_u245 = (Sink)builder$iv;
        boolean bl = false;
        $this$writeECPoint_u24lambda_u245.writeByte((byte)4);
        byte[] byArray = point.getAffineX().toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        RenderKt.writeAligned($this$writeECPoint_u24lambda_u245, byArray, fieldSize);
        byte[] byArray2 = point.getAffineY().toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"toByteArray(...)");
        RenderKt.writeAligned($this$writeECPoint_u24lambda_u245, byArray2, fieldSize);
        Source pointData = (Source)builder$iv;
        $this$writeECPoint.writeByte((byte)ByteReadPacketKt.getRemaining((Source)pointData));
        BytePacketBuilderKt.writePacket((Sink)$this$writeECPoint, (Source)pointData);
    }

    private static final Source buildSignatureAlgorithmsExtension(List<HashAndSign> algorithms) {
        boolean $i$f$buildPacket = false;
        Buffer builder$iv = new Buffer();
        Sink $this$buildSignatureAlgorithmsExtension_u24lambda_u247 = (Sink)builder$iv;
        boolean bl = false;
        $this$buildSignatureAlgorithmsExtension_u24lambda_u247.writeShort(TLSExtensionType.SIGNATURE_ALGORITHMS.getCode());
        int size = algorithms.size();
        $this$buildSignatureAlgorithmsExtension_u24lambda_u247.writeShort((short)(2 + size * 2));
        $this$buildSignatureAlgorithmsExtension_u24lambda_u247.writeShort((short)(size * 2));
        Iterable $this$forEach$iv = algorithms;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HashAndSign it = (HashAndSign)element$iv;
            boolean bl2 = false;
            $this$buildSignatureAlgorithmsExtension_u24lambda_u247.writeByte(it.getHash().getCode());
            $this$buildSignatureAlgorithmsExtension_u24lambda_u247.writeByte(it.getSign().getCode());
        }
        return (Source)builder$iv;
    }

    static /* synthetic */ Source buildSignatureAlgorithmsExtension$default(List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = SignatureAlgorithmKt.getSupportedSignatureAlgorithms();
        }
        return RenderKt.buildSignatureAlgorithmsExtension(list);
    }

    private static final Source buildServerNameExtension(String name) {
        boolean $i$f$buildPacket = false;
        Buffer builder$iv = new Buffer();
        Sink $this$buildServerNameExtension_u24lambda_u249 = (Sink)builder$iv;
        boolean bl = false;
        if (!(name.length() < 32762)) {
            boolean bl2 = false;
            String string = "Server name length limit exceeded: at most 32762 characters allowed";
            throw new IllegalArgumentException(string.toString());
        }
        $this$buildServerNameExtension_u24lambda_u249.writeShort(TLSExtensionType.SERVER_NAME.getCode());
        $this$buildServerNameExtension_u24lambda_u249.writeShort((short)(name.length() + 2 + 1 + 2));
        $this$buildServerNameExtension_u24lambda_u249.writeShort((short)(name.length() + 2 + 1));
        $this$buildServerNameExtension_u24lambda_u249.writeByte((byte)0);
        $this$buildServerNameExtension_u24lambda_u249.writeShort((short)name.length());
        StringsKt.writeText$default((Sink)$this$buildServerNameExtension_u24lambda_u249, (CharSequence)name, (int)0, (int)0, null, (int)14, null);
        return (Source)builder$iv;
    }

    private static final Source buildECCurvesExtension(List<? extends NamedCurve> curves) {
        boolean $i$f$buildPacket = false;
        Buffer builder$iv = new Buffer();
        Sink $this$buildECCurvesExtension_u24lambda_u2412 = (Sink)builder$iv;
        boolean bl = false;
        if (!(curves.size() <= 16382)) {
            boolean $i$a$-require-RenderKt$buildECCurvesExtension$1$22 = false;
            String $i$a$-require-RenderKt$buildECCurvesExtension$1$22 = "Too many named curves provided: at most 16382 could be provided";
            throw new IllegalArgumentException($i$a$-require-RenderKt$buildECCurvesExtension$1$22.toString());
        }
        $this$buildECCurvesExtension_u24lambda_u2412.writeShort(TLSExtensionType.ELLIPTIC_CURVES.getCode());
        int size = curves.size() * 2;
        $this$buildECCurvesExtension_u24lambda_u2412.writeShort((short)(2 + size));
        $this$buildECCurvesExtension_u24lambda_u2412.writeShort((short)size);
        Iterable $this$forEach$iv = curves;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NamedCurve it = (NamedCurve)((Object)element$iv);
            boolean bl2 = false;
            $this$buildECCurvesExtension_u24lambda_u2412.writeShort(it.getCode());
        }
        return (Source)builder$iv;
    }

    static /* synthetic */ Source buildECCurvesExtension$default(List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = NamedCurvesKt.getSupportedNamedCurves();
        }
        return RenderKt.buildECCurvesExtension(list);
    }

    private static final Source buildECPointFormatExtension(List<? extends PointFormat> formats) {
        boolean $i$f$buildPacket = false;
        Buffer builder$iv = new Buffer();
        Sink $this$buildECPointFormatExtension_u24lambda_u2414 = (Sink)builder$iv;
        boolean bl = false;
        $this$buildECPointFormatExtension_u24lambda_u2414.writeShort(TLSExtensionType.EC_POINT_FORMAT.getCode());
        int size = formats.size();
        $this$buildECPointFormatExtension_u24lambda_u2414.writeShort((short)(1 + size));
        $this$buildECPointFormatExtension_u24lambda_u2414.writeByte((byte)size);
        Iterable $this$forEach$iv = formats;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PointFormat it = (PointFormat)((Object)element$iv);
            boolean bl2 = false;
            $this$buildECPointFormatExtension_u24lambda_u2414.writeByte(it.getCode());
        }
        return (Source)builder$iv;
    }

    static /* synthetic */ Source buildECPointFormatExtension$default(List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = PointFormatKt.getSupportedPointFormats();
        }
        return RenderKt.buildECPointFormatExtension(list);
    }

    private static final void writeAligned(Sink $this$writeAligned, byte[] src, int fieldSize) {
        int n;
        int expectedSize;
        block2: {
            expectedSize = fieldSize + 7 >>> 3;
            byte[] $this$indexOfFirst$iv = src;
            boolean $i$f$indexOfFirst = false;
            int n2 = $this$indexOfFirst$iv.length;
            for (int index$iv = 0; index$iv < n2; ++index$iv) {
                byte it = $this$indexOfFirst$iv[index$iv];
                boolean bl = false;
                if (!(it != 0)) continue;
                n = index$iv;
                break block2;
            }
            n = -1;
        }
        int index = n;
        int padding = expectedSize - (src.length - index);
        if (padding > 0) {
            BytePacketBuilderKt.writeFully$default((Sink)$this$writeAligned, (byte[])new byte[padding], (int)0, (int)0, (int)6, null);
        }
        BytePacketBuilderKt.writeFully((Sink)$this$writeAligned, (byte[])src, (int)index, (int)(src.length - index));
    }

    private static final void writeTripleByteLength(Sink $this$writeTripleByteLength, int value) {
        int high = value >>> 16 & 0xFF;
        int low = value & 0xFFFF;
        $this$writeTripleByteLength.writeByte((byte)high);
        $this$writeTripleByteLength.writeShort((short)low);
    }
}

